///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 1999-2005 Siebel Systems, Inc.  All rights reserved.
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

function VariableSelector(eid, variableType)
{
   this.eid = eid;
   this.variableType = variableType;

   this.form = document.forms[eid + "Form"];
}

VariableSelector.prototype = new XUIEditor();

//-------------------
VariableSelector.prototype.load = function()
{
   this.variableName = null;
   this.variableDefault = null;

   this.form.variableName.value = '';
   this.form.variableDefault.value = '';

   document.getElementById(this.eid + "VariableCaption").innerHTML = 
      (this.variableType == 'web') ? kmsgVariableSelectorExpression : kmsgVariableSelectorName;

   document.getElementById(this.eid + "DefaultValue").style.display = 
      (this.variableType == 'web') ? '' : 'none';

   document.getElementById(this.eid + "EmptyRow").style.display = 
      (this.variableType == 'web') ? 'none' : '';
}

VariableSelector.prototype.focus = function()
{
   this.form.variableName.focus();
}

//-------------------
VariableSelector.prototype.apply = function()
{
   // For now, no validation.  Server now pushes on variables object so reference to x or
   // variables.x should work.  Error msg was kmsgFilterEditorInvalidWebVariableInput
   
   this.variableName = this.form.variableName.value;
   this.variableDefault = this.form.variableDefault.value;

   return true;
}

//-------------------
VariableSelector.prototype.discard = function()
{
   this.parentEditor.discard();
}

